<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 7/30/2019
 * Time: 1:56 PM
 */
namespace Modules\Gig\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\AdminController;
use Modules\Core\Events\CreatedServicesEvent;
use Modules\Core\Events\UpdatedServiceEvent;
use Modules\Gig\Models\Gig;
use Modules\Gig\Models\GigOrder;
use Modules\Gig\Models\GigCategory;
use Modules\Gig\Models\GigTerm;
use Modules\Gig\Models\GigTranslation;
use Modules\Core\Models\Attributes;
use Modules\Location\Models\Location;

class GigOrderController extends AdminController
{
    protected $gig;
    protected $gig_translation;
    protected $gig_term;
    protected $attributes;
    protected $location;

    public function __construct()
    {
        parent::__construct();
        if(!is_admin()){
            $this->middleware('verified');
        }
        $this->setActiveMenu(route('gig.admin.index'));
        $this->gig_order = GigOrder::class;
        $this->gig_translation = GigTranslation::class;
        $this->gig_term = GigTerm::class;
        $this->attributes = Attributes::class;
        $this->location = Location::class;
    }

    public function callAction($method, $parameters)
    {
        if(!Gig::isEnable())
        {
            return redirect('/');
        }
        return parent::callAction($method, $parameters); // TODO: Change the autogenerated stub
    }
    public function index(Request $request)
    {
        $this->checkPermission('gig_manage_others');
        $query = $this->gig_order::query()->whereHas('gig')->orderByDesc('id');
        if (!empty($s = $request->input('s'))) {
            $query->where('title', 'LIKE', '%' . $s . '%');
            $query->orderBy('title', 'asc');
        }
        if($s = $request->query('status')){
            $query->where('status',$s);
        }
        if($author_id = $request->query('author_id')){
            $query->where('author_id',$author_id);
        }
        if($customer_id = $request->query('customer_id')){
            $query->where('customer_id',$customer_id);
        }
        $data = [
            'rows'               => $query->with(['author','customer','gig'])->paginate(20),
            'breadcrumbs'        => [
                [
                    'name' => __('Manage Orders'),
                    'url'  => route('gig_order.admin.index'),
                    'class' => 'active'
                ],
            ],
            'page_title'=>__("Manage Orders")
        ];
        return view('Gig::admin.order_gig.index', $data);
    }

    public function bulkEdit(Request $request)
    {

        $this->checkPermission('gig_manage_others');
        $ids = $request->input('ids');
        $action = $request->input('action');
        if (empty($ids) or !is_array($ids)) {
            return redirect()->back()->with('error', __('No items selected!'));
        }
        if (empty($action)) {
            return redirect()->back()->with('error', __('Please select an action!'));
        }

        switch ($action){
            case "delete":
                foreach ($ids as $id) {
                    $query = $this->gig_order::where("id", $id);
                    $row = $query->first();
                    if(!empty($row)){
                        $row->delete();
                        //event(new UpdatedServiceEvent($row));
                    }
                }
                return redirect()->back()->with('success', __('Deleted success!'));
                break;
            default:
                // Change status
                foreach ($ids as $id) {
                    $query = $this->gig_order::where("id", $id);
                    $row = $query->first();
                    $row->status  = $action;
                    $row->save();
                    //event(new UpdatedServiceEvent($row));
                }
                return redirect()->back()->with('success', __('Update success!'));
                break;
        }
    }

}
